using Microsoft.VisualBasic;
using System;
using System.Collections;
using System.Collections.Generic;


namespace StrataFlix.UI
{
	namespace Windows
	{
		namespace Forms
		{
			
			
			public class ActionLinkMenuItemCollection : CollectionBase, IEnumerable<ActionLinkMenuItem>
			{
				
				
				#region " Constructors "
				
				/// <summary>
				/// Initializes a new instance of the ActionLinkMenuItemCollection class.
				/// </summary>
				/// <remarks></remarks>
				public ActionLinkMenuItemCollection()
				{
				}
				
				#endregion
				
				#region " Events "
				
				#region " ListChanged "
				
				/// <summary>
				/// Occurs when an item is added or removed from this collection.
				/// </summary>
				/// <remarks></remarks>
				private EventHandler ListChangedEvent;
				public event EventHandler ListChanged
				{
					add
					{
						ListChangedEvent = (EventHandler) System.Delegate.Combine(ListChangedEvent, value);
					}
					remove
					{
						ListChangedEvent = (EventHandler) System.Delegate.Remove(ListChangedEvent, value);
					}
				}
				
				
				/// <summary>
				/// Raises the ListChanged event.
				/// </summary>
				/// <remarks></remarks>
				protected void OnListChanged()
				{
					if (! this._IsFrozen)
					{
						if (ListChangedEvent != null)
							ListChangedEvent(this, EventArgs.Empty);
					}
				}
				
				#endregion
				
				#endregion
				
				#region " Private Fields "
				
				private bool _IsFrozen = false;
				
				#endregion
				
				#region " Public Properties "
				
				/// <summary>
				/// Gets or sets the ActionLinkMenuItem within this collection at the specified index.
				/// </summary>
				/// <param name="Index"></param>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public ActionLinkMenuItem this[int Index]
				{
					get
					{
						return ((ActionLinkMenuItem) this.List);
					}
					set
					{
						this.List[Index] = value;
					}
				}
				
				#endregion
				
				#region " Protected Methods "
				
				/// <summary>
				/// Overrides the OnClearComplete() method of the base class.
				/// </summary>
				/// <remarks></remarks>
				protected override void OnClearComplete()
				{
					//-- Call the base method
					base.OnClearComplete();
					
					//-- Raise the changed event
					this.OnListChanged();
				}
				
				/// <summary>
				/// Overrides the OnInsertComplete() method of the base class.
				/// </summary>
				/// <param name="index"></param>
				/// <param name="value"></param>
				/// <remarks></remarks>
				protected override void OnInsertComplete(int index, object value)
				{
					//-- Call the base method
					base.OnInsertComplete(index, value);
					
					//-- Raise the changed event
					this.OnListChanged();
				}
				
				/// <summary>
				/// Overrides the OnRemoveComplete() method of the base class.
				/// </summary>
				/// <param name="index"></param>
				/// <param name="value"></param>
				/// <remarks></remarks>
				protected override void OnRemoveComplete(int index, object value)
				{
					//-- Call the base method
					base.OnRemoveComplete(index, value);
					
					//-- Raise the changed event
					this.OnListChanged();
				}
				
				/// <summary>
				/// Overrides the OnSetComplete() method of the base class.
				/// </summary>
				/// <param name="index"></param>
				/// <param name="oldValue"></param>
				/// <param name="newValue"></param>
				/// <remarks></remarks>
				protected override void OnSetComplete(int index, object oldValue, object newValue)
				{
					//-- Call the base method
					base.OnSetComplete(index, oldValue, newValue);
					
					//-- Raise the changed event
					this.OnListChanged();
				}
				
				#endregion
				
				#region " Public Methods "
				
				/// <summary>
				/// Adds the specified item to this collection.
				/// </summary>
				/// <param name="Item"></param>
				/// <returns></returns>
				/// <remarks></remarks>
				public int Add(ActionLinkMenuItem Item)
				{
					return this.List.Add(Item);
				}
				
				/// <summary>
				/// Sets the collection so that changed events will not be raised until the collection
				/// is thawed.
				/// </summary>
				/// <remarks></remarks>
				public void Freeze()
				{
					this._IsFrozen = true;
				}
				
				/// <summary>
				/// Gets a generic enumerator for this collection.
				/// </summary>
				/// <returns></returns>
				/// <remarks></remarks>
				public new IEnumerator<ActionLinkMenuItem> GetEnumerator()
				{
					return this.GetGenericEnumerator();
				}
				
				public IEnumerator<ActionLinkMenuItem> GetGenericEnumerator()
				{
					List<ActionLinkMenuItem> loReturn = new List<ActionLinkMenuItem>(this.Count);
					foreach (ActionLinkMenuItem item in this.List)
					{
						loReturn.Add(item);
					}
					return loReturn.GetEnumerator();
				}
				
				/// <summary>
				/// Returns the index of the specified item
				/// </summary>
				/// <param name="item"></param>
				/// <returns></returns>
				/// <remarks></remarks>
				public int IndexOf(ActionLinkMenuItem item)
				{
					return List.IndexOf(item);
				}
				
				/// <summary>
				/// Removes the specified item from this collection.
				/// </summary>
				/// <param name="Item"></param>
				/// <remarks></remarks>
				public void Remove(ActionLinkMenuItem Item)
				{
					this.List.Remove(Item);
				}
				
				/// <summary>
				/// Sets the collection to where it can raise changed events again.
				/// </summary>
				/// <remarks></remarks>
				public void Thaw()
				{
					this._IsFrozen = false;
					this.OnListChanged();
				}
				
				#endregion
				
			}
			
		}
	}
}
